/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.command.dml;

import java.util.ArrayList;
import org.h14199.command.Command;
import org.h14199.command.Prepared;
import org.h14199.command.dml.CommandWithValues;
import org.h14199.command.dml.Query;
import org.h14199.engine.Mode;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.Parameter;
import org.h14199.index.Index;
import org.h14199.message.DbException;
import org.h14199.result.ResultInterface;
import org.h14199.result.Row;
import org.h14199.table.Column;
import org.h14199.table.Table;
import org.h14199.value.Value;

public class Replace
extends CommandWithValues {
    private Table table;
    private Column[] columns;
    private Column[] keys;
    private Query query;
    private Prepared update;

    public Replace(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setKeys(Column[] columnArray) {
        this.keys = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    @Override
    public int update() {
        int n = 0;
        this.session.getUser().checkRight(this.table, 4);
        this.session.getUser().checkRight(this.table, 8);
        this.setCurrentRowNumber(0L);
        Mode mode = this.session.getDatabase().getMode();
        if (!this.valuesExpressionList.isEmpty()) {
            int n2 = this.valuesExpressionList.size();
            for (int i = 0; i < n2; ++i) {
                this.setCurrentRowNumber(i + 1);
                Expression[] expressionArray = (Expression[])this.valuesExpressionList.get(i);
                Row row = this.table.getTemplateRow();
                int n3 = this.columns.length;
                for (int j = 0; j < n3; ++j) {
                    Column column = this.columns[j];
                    int n4 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    try {
                        Value value = column.convert(expression.getValue(this.session), mode);
                        row.setValue(n4, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, Replace.getSimpleSQL(expressionArray));
                    }
                }
                n += this.replace(row);
            }
        } else {
            ResultInterface resultInterface = this.query.query(0);
            this.table.fire(this.session, 3, true);
            this.table.lock(this.session, true, false);
            while (resultInterface.next()) {
                Value[] valueArray = resultInterface.currentRow();
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(n);
                for (int i = 0; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    int n5 = column.getColumnId();
                    try {
                        Value value = column.convert(valueArray[i], mode);
                        row.setValue(n5, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, Replace.getSQL(valueArray));
                    }
                }
                n += this.replace(row);
            }
            resultInterface.close();
            this.table.fire(this.session, 3, false);
        }
        return n;
    }

    private int replace(Row row) {
        int n = this.update(row);
        if (n == 0) {
            try {
                this.table.validateConvertUpdateSequence(this.session, row);
                boolean bl = this.table.fireBeforeRow(this.session, null, row);
                if (!bl) {
                    this.table.lock(this.session, true, false);
                    this.table.addRow(this.session, row);
                    this.session.log(this.table, (short)0, row);
                    this.table.fireAfterRow(this.session, null, row, false);
                }
                return 1;
            }
            catch (DbException dbException) {
                Index index;
                if (dbException.getErrorCode() == 23505 && (index = (Index)dbException.getSource()) != null) {
                    Column[] columnArray = index.getColumns();
                    boolean bl = false;
                    if (columnArray.length <= this.keys.length) {
                        for (int i = 0; i < columnArray.length; ++i) {
                            if (columnArray[i] == this.keys[i]) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (bl) {
                        throw DbException.get(90131, this.table.getName());
                    }
                }
                throw dbException;
            }
        }
        if (n == 1) {
            return 2;
        }
        throw DbException.get(23505, this.table.getSQL(false));
    }

    private int update(Row row) {
        Parameter parameter;
        Value value;
        Column column;
        int n;
        if (this.update == null) {
            return 0;
        }
        ArrayList<Parameter> arrayList = this.update.getParameters();
        for (n = 0; n < this.columns.length; ++n) {
            column = this.columns[n];
            value = row.getValue(column.getColumnId());
            parameter = arrayList.get(n);
            parameter.setValue(value);
        }
        for (n = 0; n < this.keys.length; ++n) {
            column = this.keys[n];
            value = row.getValue(column.getColumnId());
            if (value == null) {
                throw DbException.get(90081, column.getSQL(false));
            }
            parameter = arrayList.get(this.columns.length + n);
            parameter.setValue(value);
        }
        return this.update.update();
    }

    @Override
    public String getPlanSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("REPLACE INTO ");
        this.table.getSQL(stringBuilder, bl).append('(');
        Column.writeColumns(stringBuilder, this.columns, bl);
        stringBuilder.append(')');
        stringBuilder.append('\n');
        if (!this.valuesExpressionList.isEmpty()) {
            stringBuilder.append("VALUES ");
            int n = 0;
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (n++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('(');
                Expression.writeExpressions(stringBuilder, expressionArray, bl);
                stringBuilder.append(')');
            }
        } else {
            stringBuilder.append(this.query.getPlanSQL(bl));
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        Object object;
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && ((Expression[])this.valuesExpressionList.get(0)).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (expressionArray.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i = 0; i < expressionArray.length; ++i) {
                    Expression object2 = expressionArray[i];
                    if (object2 == null) continue;
                    expressionArray[i] = object2.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            object = this.table.getPrimaryKey();
            if (object == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = object.getColumns();
        }
        for (Column column : this.keys) {
            boolean bl = false;
            for (Column column2 : this.columns) {
                if (column2.getColumnId() != column.getColumnId()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return;
        }
        object = new StringBuilder("UPDATE ");
        this.table.getSQL((StringBuilder)object, true).append(" SET ");
        Column.writeColumns((StringBuilder)object, this.columns, ", ", "=?", true).append(" WHERE ");
        Column.writeColumns((StringBuilder)object, this.keys, " AND ", "=?", true);
        this.update = this.session.prepare(((StringBuilder)object).toString());
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 63;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

